var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};

// data/system_template_esbuild/subscripts/starting_book.ts
import { world } from "@minecraft/server";
var DEBUG = false;
var NAMESPACE = "shapescape_sdi:";
var TAG = "book";
var PATH_NAMESPACE = "shapescape/sdi/";
world.afterEvents.playerSpawn.subscribe((event) => {
  givePlayerBook(event.player);
});
function givePlayerBook(player) {
  player.runCommand(
    `execute as @s[tag=!${NAMESPACE.substring(
      0,
      NAMESPACE.length - 1
    )}_${TAG}] at @s run loot spawn ~ ~ ~ loot "${PATH_NAMESPACE}starting_book"`
  );
  player.runCommand(
    `tag @s[tag=!${NAMESPACE.substring(
      0,
      NAMESPACE.length - 1
    )}] add ${NAMESPACE.substring(0, NAMESPACE.length - 1)}_${TAG}`
  );
  if (DEBUG) {
    world.sendMessage(`Given Player Book`);
  }
}

// data/system_template_esbuild/subscripts/guide_book.ts
import { system as system6 } from "@minecraft/server";

// data/node_modules/@bedrock-oss/bedrock-boost/dist/index.mjs
import { Direction } from "@minecraft/server";
import { system, world as world2 } from "@minecraft/server";
import { system as system2 } from "@minecraft/server";
import { BlockPermutation, world as world22 } from "@minecraft/server";
import { world as world3 } from "@minecraft/server";
import { Player } from "@minecraft/server";
import { system as system3 } from "@minecraft/server";
import { EquipmentSlot } from "@minecraft/server";
import { system as system4 } from "@minecraft/server";
import { MinecraftDimensionTypes, world as world4 } from "@minecraft/server";
import { Player as Player3, system as system5, world as world5 } from "@minecraft/server";
var _a;
var ChatColor = (_a = class {
  /**
   * Class ChatColor Constructor.
   * @param code - The color code as a string.
   * @param color - The color code as a hexadecimal number. Can be undefined.
   */
  constructor(code, color) {
    __publicField(this, "r");
    __publicField(this, "g");
    __publicField(this, "b");
    this.code = code;
    this.color = color;
    if (color) {
      this.r = color >> 16 & 255;
      this.g = color >> 8 & 255;
      this.b = color & 255;
    }
  }
  /**
   * Returns the string representation of the ChatColor instance,
   * which includes the PREFIX followed by the color code.
   * @returns A string representing the ChatColor instance
   */
  toString() {
    return _a.PREFIX + this.code;
  }
  /**
   * Returns the color code of the ChatColor instance.
   * @returns The color code of this ChatColor instance.
   */
  toRGB() {
    return this.color;
  }
  /**
   * Returns the hexadecimal string representation of the color code
   * @returns {string | undefined} The hexadecimal representation of the color.
   */
  toHex() {
    return this.color?.toString(16);
  }
  /**
   * Retrieve the value of the red component.
   *
   * @returns {number | undefined} The value of the red component, or undefined if it is not set.
   */
  getRed() {
    return this.r;
  }
  /**
   * Retrieves the green value of the current color.
   *
   * @returns {number | undefined} The green value of the color, or undefined if it is not set.
   */
  getGreen() {
    return this.g;
  }
  /**
   * Retrieves the blue value of a color.
   *
   * @returns The blue value of the color.
   * @type {number | undefined}
   */
  getBlue() {
    return this.b;
  }
  /**
   * Retrieves the format code associated with the chat color.
   *
   * @returns {string} The format code of the chat color.
   */
  getCode() {
    return this.code;
  }
  /**
   * Removes color codes from the specified string
   * @param str - The string from which color codes will be removed.
   * @returns The string cleared from color codes.
   */
  static stripColor(str) {
    return str.replace(/§[0-9a-u]/g, "");
  }
  /**
   * Finds the closest ChatColor code for the given RGB values
   * @param r - Red part of the color.
   * @param g - Green part of the color.
   * @param b - Blue part of the color.
   * @returns The closest ChatColor for the given RGB values.
   */
  static findClosestColor(r, g, b) {
    let minDistance = Number.MAX_VALUE;
    let closestColor = _a.WHITE;
    for (const color of _a.ALL_COLORS) {
      if (color.r && color.g && color.b) {
        const distance = Math.sqrt(Math.pow(color.r - r, 2) + Math.pow(color.g - g, 2) + Math.pow(color.b - b, 2));
        if (distance < minDistance) {
          minDistance = distance;
          closestColor = color;
        }
      }
    }
    return closestColor;
  }
}, __publicField(_a, "BLACK", new _a("0", 0)), __publicField(_a, "DARK_BLUE", new _a("1", 170)), __publicField(_a, "DARK_GREEN", new _a("2", 43520)), __publicField(_a, "DARK_AQUA", new _a("3", 43690)), __publicField(_a, "DARK_RED", new _a("4", 11141120)), __publicField(_a, "DARK_PURPLE", new _a("5", 11141290)), __publicField(_a, "GOLD", new _a("6", 16755200)), __publicField(_a, "GRAY", new _a("7", 11184810)), __publicField(_a, "DARK_GRAY", new _a("8", 5592405)), __publicField(_a, "BLUE", new _a("9", 5592575)), __publicField(_a, "GREEN", new _a("a", 5635925)), __publicField(_a, "AQUA", new _a("b", 5636095)), __publicField(_a, "RED", new _a("c", 16733525)), __publicField(_a, "LIGHT_PURPLE", new _a("d", 16733695)), __publicField(_a, "YELLOW", new _a("e", 16777045)), __publicField(_a, "WHITE", new _a("f", 16777215)), __publicField(_a, "MINECOIN_GOLD", new _a("g", 14603781)), __publicField(_a, "MATERIAL_QUARTZ", new _a("h", 14931153)), __publicField(_a, "MATERIAL_IRON", new _a("i", 13552330)), __publicField(_a, "MATERIAL_NETHERITE", new _a("j", 4471355)), __publicField(_a, "MATERIAL_REDSTONE", new _a("m", 9901575)), __publicField(_a, "MATERIAL_COPPER", new _a("n", 11823181)), __publicField(_a, "MATERIAL_GOLD", new _a("p", 14594349)), __publicField(_a, "MATERIAL_EMERALD", new _a("q", 1155126)), __publicField(_a, "MATERIAL_DIAMOND", new _a("s", 2931368)), __publicField(_a, "MATERIAL_LAPIS", new _a("t", 2181499)), __publicField(_a, "MATERIAL_AMETHYST", new _a("u", 10116294)), __publicField(_a, "OBFUSCATED", new _a("k")), __publicField(_a, "BOLD", new _a("l")), __publicField(_a, "ITALIC", new _a("o")), __publicField(_a, "RESET", new _a("r")), __publicField(_a, "VALUES", [
  _a.BLACK,
  _a.DARK_BLUE,
  _a.DARK_GREEN,
  _a.DARK_AQUA,
  _a.DARK_RED,
  _a.DARK_PURPLE,
  _a.GOLD,
  _a.GRAY,
  _a.DARK_GRAY,
  _a.BLUE,
  _a.GREEN,
  _a.AQUA,
  _a.RED,
  _a.LIGHT_PURPLE,
  _a.YELLOW,
  _a.WHITE,
  _a.MINECOIN_GOLD,
  _a.MATERIAL_QUARTZ,
  _a.MATERIAL_IRON,
  _a.MATERIAL_NETHERITE,
  _a.MATERIAL_REDSTONE,
  _a.MATERIAL_COPPER,
  _a.MATERIAL_GOLD,
  _a.MATERIAL_EMERALD,
  _a.MATERIAL_DIAMOND,
  _a.MATERIAL_LAPIS,
  _a.MATERIAL_AMETHYST,
  _a.OBFUSCATED,
  _a.BOLD,
  _a.ITALIC,
  _a.RESET
]), __publicField(_a, "ALL_COLORS", [
  _a.BLACK,
  _a.DARK_BLUE,
  _a.DARK_GREEN,
  _a.DARK_AQUA,
  _a.DARK_RED,
  _a.DARK_PURPLE,
  _a.GOLD,
  _a.GRAY,
  _a.DARK_GRAY,
  _a.BLUE,
  _a.GREEN,
  _a.AQUA,
  _a.RED,
  _a.LIGHT_PURPLE,
  _a.YELLOW,
  _a.WHITE,
  _a.MINECOIN_GOLD,
  _a.MATERIAL_QUARTZ,
  _a.MATERIAL_IRON,
  _a.MATERIAL_NETHERITE,
  _a.MATERIAL_REDSTONE,
  _a.MATERIAL_COPPER,
  _a.MATERIAL_GOLD,
  _a.MATERIAL_EMERALD,
  _a.MATERIAL_DIAMOND,
  _a.MATERIAL_LAPIS,
  _a.MATERIAL_AMETHYST
]), /**
 * PREFIX is the section sign (§) used in Minecraft color codes.
 */
__publicField(_a, "PREFIX", "\xA7"), _a);
var _a2;
var ColorJSON = (_a2 = class {
  constructor() {
    // Tokens
    __publicField(this, "OpenObject", "{");
    __publicField(this, "CloseObject", "}");
    __publicField(this, "OpenArray", "[");
    __publicField(this, "CloseArray", "]");
    __publicField(this, "Comma", ",");
    __publicField(this, "KeyValueSeparator", ":");
    __publicField(this, "StringDelimiter", '"');
    __publicField(this, "KeyDelimiter", "");
    __publicField(this, "Indent", "  ");
    __publicField(this, "NewLine", "\n");
    __publicField(this, "Space", " ");
    // Threshold for inline representation
    __publicField(this, "InlineThreshold", 60);
    // Maximum depth to which objects will be traversed
    __publicField(this, "MaxDepth", 1);
    // Whether to include class names
    __publicField(this, "IncludeClassNames", true);
    // Values
    __publicField(this, "FunctionValue", "\u0192");
    __publicField(this, "NullValue", "null");
    __publicField(this, "UndefinedValue", "undefined");
    __publicField(this, "TrueValue", "true");
    __publicField(this, "FalseValue", "false");
    __publicField(this, "CycleValue", "[...cycle...]");
    __publicField(this, "TruncatedObjectValue", "{...}");
    // Colors
    __publicField(this, "OpenCloseObjectColor", ChatColor.YELLOW);
    __publicField(this, "OpenCloseArrayColor", ChatColor.AQUA);
    __publicField(this, "NumberColor", ChatColor.DARK_AQUA);
    __publicField(this, "StringColor", ChatColor.DARK_GREEN);
    __publicField(this, "BooleanColor", ChatColor.GOLD);
    __publicField(this, "NullColor", ChatColor.GOLD);
    __publicField(this, "KeyColor", ChatColor.GRAY);
    __publicField(this, "EscapeColor", ChatColor.GOLD);
    __publicField(this, "FunctionColor", ChatColor.GRAY);
    __publicField(this, "ClassColor", ChatColor.GRAY);
    __publicField(this, "ClassStyle", ChatColor.BOLD);
    __publicField(this, "CycleColor", ChatColor.DARK_RED);
  }
  /**
   * Transforms a value into a chat-friendly, colored JSON representation.
   * @param value - The value to transform.
   */
  stringify(value) {
    return this.stringifyValue(value);
  }
  /**
   * Transforms a string into a JSON representation.
   * @param value - The string to transform.
   */
  stringifyString(value) {
    return this.StringColor + this.StringDelimiter + this.escapeString(value) + this.StringDelimiter + ChatColor.RESET;
  }
  /**
   * Transforms a number into a JSON representation.
   * @param value - The number to transform.
   */
  stringifyNumber(value) {
    return this.NumberColor + value.toString() + ChatColor.RESET;
  }
  /**
   * Transforms a boolean into a JSON representation.
   * @param value - The boolean to transform.
   */
  stringifyBoolean(value) {
    return this.BooleanColor + (value ? this.TrueValue : this.FalseValue) + ChatColor.RESET;
  }
  /**
   * Transforms a function into a JSON representation.
   * @param value - The function to transform.
   */
  // eslint-disable-next-line @typescript-eslint/ban-types
  stringifyFunction(value) {
    return this.FunctionColor + this.FunctionValue + ChatColor.RESET;
  }
  /**
   * Returns a null JSON representation.
   */
  stringifyNull() {
    return this.NullColor + this.NullValue + ChatColor.RESET;
  }
  /**
   * Returns an undefined JSON representation.
   */
  stringifyUndefined() {
    return this.NullColor + this.UndefinedValue + ChatColor.RESET;
  }
  /**
   * Returns a cycle JSON representation.
   */
  stringifyCycle() {
    return this.CycleColor + this.CycleValue + ChatColor.RESET;
  }
  /**
   * Transforms an array into a JSON representation.
   * @param value - The array to transform.
   * @param indentLevel - The indentation level for pretty-printing.
   */
  stringifyArray(value, indentLevel = 0) {
    const indentSpace = this.Indent.repeat(indentLevel);
    if (value.length === 0) {
      return this.OpenCloseArrayColor + this.OpenArray + this.CloseArray + ChatColor.RESET;
    }
    let result = this.OpenCloseArrayColor + this.OpenArray + ChatColor.RESET + this.NewLine;
    let compactResult = this.OpenCloseArrayColor + this.OpenArray + ChatColor.RESET;
    value.forEach((item, index) => {
      result += indentSpace + this.Indent + this.stringifyValue(item, indentLevel + 1);
      result += index < value.length - 1 ? this.Comma + this.NewLine : this.NewLine;
      compactResult += this.stringifyValue(item, indentLevel + 1);
      compactResult += index < value.length - 1 ? this.Comma + this.Space : "";
    });
    result += indentSpace + this.OpenCloseArrayColor + this.CloseArray + ChatColor.RESET;
    compactResult += this.OpenCloseArrayColor + this.CloseArray + ChatColor.RESET;
    if (compactResult.length < this.InlineThreshold) {
      return compactResult;
    }
    return result;
  }
  /**
   * Transforms an object into a truncated JSON representation.
   * @param value - The object to transform.
   * @param className - Class Name of the object.
   * @param indentLevel - The indentation level for pretty-printing.
   */
  stringifyTruncatedObject(value, className, indentLevel = 0) {
    return (this.IncludeClassNames ? this.ClassColor + "" + this.ClassStyle + className + ChatColor.RESET + this.Space : "") + this.TruncatedObjectValue;
  }
  /**
   * Transforms an object into a JSON representation.
   * @param value - The object to transform.
   * @param className - Class Name of the object.
   * @param entries - Entries of the object to transform.
   * @param indentLevel - The indentation level for pretty-printing.
   */
  stringifyObject(value, className, entries, indentLevel = 0) {
    const indentSpace = this.Indent.repeat(indentLevel);
    const prefix = this.IncludeClassNames && className !== "Object" ? this.ClassColor + "" + this.ClassStyle + className + ChatColor.RESET + this.Space : "";
    if (entries.length === 0) {
      return prefix + this.OpenCloseObjectColor + this.OpenObject + this.CloseObject + ChatColor.RESET;
    }
    let result = prefix + this.OpenCloseObjectColor + this.OpenObject + ChatColor.RESET + this.NewLine;
    let compactResult = prefix + this.OpenCloseObjectColor + this.OpenObject + ChatColor.RESET;
    entries.forEach(([key, val], index) => {
      const compactVal = this.stringifyValue(val, indentLevel + 1);
      result += indentSpace + this.Indent + this.KeyColor + this.KeyDelimiter + key + this.KeyDelimiter + ChatColor.RESET + this.KeyValueSeparator + this.Space + compactVal;
      result += index < entries.length - 1 ? this.Comma + this.NewLine : this.NewLine;
      compactResult += this.KeyColor + key + ChatColor.RESET + this.KeyValueSeparator + this.Space + compactVal;
      compactResult += index < entries.length - 1 ? this.Comma + this.Space : "";
    });
    result += indentSpace + this.OpenCloseObjectColor + this.CloseObject + ChatColor.RESET;
    compactResult += this.OpenCloseObjectColor + this.CloseObject + ChatColor.RESET;
    if (compactResult.length < this.InlineThreshold) {
      return compactResult;
    }
    return result;
  }
  shouldTruncateObject(value, className, indentLevel = 0) {
    return !(className === "Object" || indentLevel <= this.MaxDepth || this.MaxDepth <= 0);
  }
  /**
   * Transforms a value of any type into a JSON representation. This function is not meant to be overridden.
   * @param value - The value to transform.
   * @param indentLevel - The indentation level for pretty-printing.
   */
  stringifyValue(value, indentLevel = 0) {
    if (value === null)
      return this.stringifyNull();
    if (value === void 0)
      return this.stringifyUndefined();
    if (typeof value === "number")
      return this.stringifyNumber(value);
    if (typeof value === "string")
      return this.stringifyString(value);
    if (typeof value === "boolean")
      return this.stringifyBoolean(value);
    if (typeof value === "function")
      return this.stringifyFunction(value);
    if (this.isCycle(value)) {
      return this.stringifyCycle();
    }
    this.markCycle(value);
    if (Array.isArray(value)) {
      const result = this.stringifyArray(value, indentLevel ? indentLevel + 1 : 0);
      this.clearCycle(value);
      return result;
    }
    if (typeof value === "object") {
      const name = value.constructor.name;
      if (!this.shouldTruncateObject(value, name, indentLevel)) {
        const keySet = /* @__PURE__ */ new Set();
        let prototype = Object.getPrototypeOf(value);
        let keys = Object.keys(prototype);
        while (keys.length > 0) {
          keys.forEach((key) => keySet.add(key));
          prototype = Object.getPrototypeOf(prototype);
          keys = Object.keys(prototype);
        }
        Object.keys(value).forEach((key) => keySet.add(key));
        keySet.delete("__cycleDetection__");
        const allKeys = [...keySet].sort();
        const entries = allKeys.map((key) => {
          try {
            return [key, value[key] ?? void 0];
          } catch (e) {
            return [key, void 0];
          }
        }).filter(([, val]) => typeof val !== "function" && val !== void 0);
        const result = this.stringifyObject(value, name, entries, indentLevel);
        this.clearCycle(value);
        return result;
      } else {
        const result = this.stringifyTruncatedObject(value, name, indentLevel);
        this.clearCycle(value);
        return result;
      }
    }
    this.clearCycle(value);
    return ChatColor.RESET + value.toString();
  }
  /**
   * Escapes a string for JSON.
   * @param str - The string to escape.
   */
  escapeString(str) {
    return str.replace(/\\/g, this.EscapeColor + "\\\\" + this.StringColor).replace(/"/g, this.EscapeColor + '\\"' + this.StringColor).replace(/\n/g, this.EscapeColor + "\\n" + this.StringColor).replace(/\r/g, this.EscapeColor + "\\r" + this.StringColor).replace(/\t/g, this.EscapeColor + "\\t" + this.StringColor);
  }
  markCycle(value) {
    value.__cycleDetection__ = true;
  }
  isCycle(value) {
    return !!value.__cycleDetection__;
  }
  clearCycle(value) {
    delete value.__cycleDetection__;
  }
}, __publicField(_a2, "DEFAULT", new _a2()), _a2);
var _a3;
var LogLevel = (_a3 = class {
  /**
   * The constructor for each log level.
   *
   * @param {number} level - The numerical level for this logger.
   * @param {string} name - The string name for this logger.
   * @param {ChatColor} color - The color to use for this logger. Defaults to `ChatColor.RESET`.
   */
  constructor(level, name, color = ChatColor.RESET) {
    this.level = level;
    this.name = name;
    this.color = color;
  }
  /**
   * Return the logging level as a string.
   *
   * @returns {string} The string representation of the logging level.
   */
  toString() {
    return this.color + this.name.toUpperCase() + ChatColor.RESET;
  }
  /**
   * Parse a string to get the corresponding `LogLevel`.
   *
   * @param {string} str - The string to parse.
   * @returns {LogLevel} The corresponding `LogLevel`, or `undefined` if none was found.
   */
  static parse(str) {
    str = str.toLowerCase();
    for (const level of _a3.values) {
      if (level.name === str)
        return level;
    }
    const num = parseInt(str);
    if (!isNaN(num)) {
      for (const level of _a3.values) {
        if (level.level === num)
          return level;
      }
    }
    return void 0;
  }
}, __publicField(_a3, "All", new _a3(-2, "all")), __publicField(_a3, "Trace", new _a3(-2, "trace", ChatColor.DARK_AQUA)), __publicField(_a3, "Debug", new _a3(-1, "debug", ChatColor.AQUA)), __publicField(_a3, "Info", new _a3(0, "info", ChatColor.GREEN)), __publicField(_a3, "Warn", new _a3(1, "warn", ChatColor.GOLD)), __publicField(_a3, "Error", new _a3(2, "error", ChatColor.RED)), __publicField(_a3, "Fatal", new _a3(3, "fatal", ChatColor.DARK_RED)), __publicField(_a3, "Off", new _a3(100, "off")), /**
 * The list of all available log levels.
 */
__publicField(_a3, "values", [
  _a3.All,
  _a3.Trace,
  _a3.Debug,
  _a3.Info,
  _a3.Warn,
  _a3.Error,
  _a3.Fatal,
  _a3.Off
]), _a3);
function starMatch(pattern, str) {
  if (pattern === "*")
    return true;
  if (pattern.includes("*")) {
    if (pattern.startsWith("*")) {
      return str.endsWith(pattern.substring(1));
    }
    if (pattern.endsWith("*")) {
      return str.startsWith(pattern.substring(0, pattern.length - 1));
    }
    const regex = new RegExp(pattern.replace(/\*/g, ".*"));
    return regex.test(str);
  }
  return pattern === str;
}
var loggingSettings = {
  level: LogLevel.Info,
  filter: ["*"],
  outputTags: false,
  formatFunction: (level, logger, message, tags = void 0) => {
    const _tags = tags !== void 0 ? `\xA77${tags.map((tag) => `[${tag}]`).join("")}\xA7r` : "";
    return `[${level}][${ChatColor.MATERIAL_EMERALD}${logger.name}${ChatColor.RESET}]${_tags} ${message}`;
  },
  messagesJoinFunction: (messages) => {
    return messages.join(" ");
  },
  jsonFormatter: ColorJSON.DEFAULT,
  outputConfig: {
    [LogLevel.Trace.level]: [
      0,
      1
      /* ConsoleInfo */
    ],
    [LogLevel.Debug.level]: [
      0,
      1
      /* ConsoleInfo */
    ],
    [LogLevel.Info.level]: [
      0,
      1
      /* ConsoleInfo */
    ],
    [LogLevel.Warn.level]: [
      0,
      1,
      2
      /* ConsoleWarn */
    ],
    [LogLevel.Error.level]: [
      0,
      1,
      3
      /* ConsoleError */
    ],
    [LogLevel.Fatal.level]: [
      0,
      1,
      3
      /* ConsoleError */
    ]
  }
};
var _a4;
var Logger = (_a4 = class {
  /**
  * Construct a new Logger
  *
  * @param {string} name - The name of the Logger.
  * @param {string[]} tags - The tags for the logger as strings.
  */
  constructor(name, tags = []) {
    this.name = name;
    this.tags = tags;
  }
  /**
  *  Initialize logger class
  */
  static init() {
    LOGGING: {
      if (_a4.initialized)
        return;
      _a4.initialized = true;
      system.afterEvents.scriptEventReceive.subscribe((ev) => {
        if (ev.id === "logging:level" || ev.id === "log:level") {
          if (!ev.message) {
            loggingSettings.level = LogLevel.Info;
            world2.sendMessage(`${ChatColor.AQUA}Logging level set to ${ChatColor.BOLD}${loggingSettings.level}`);
          } else {
            const level = LogLevel.parse(ev.message);
            if (level) {
              loggingSettings.level = level;
              world2.sendMessage(`${ChatColor.AQUA}Logging level set to ${ChatColor.BOLD}${loggingSettings.level}`);
            } else {
              world2.sendMessage(`${ChatColor.DARK_RED}Invalid logging level: ${ev.message}`);
            }
          }
        } else if (ev.id === "logging:filter" || ev.id === "log:filter") {
          if (!ev.message) {
            loggingSettings.filter = ["*"];
          } else {
            loggingSettings.filter = ev.message.split(",");
          }
          world2.sendMessage(`${ChatColor.AQUA}Logging filter set to ${ChatColor.BOLD}${loggingSettings.filter.join(", ")}`);
        }
      });
    }
  }
  /**
  * @param {LogLevel} level - The level to set.
  */
  static setLevel(level) {
    loggingSettings.level = level;
  }
  /**
  * Filter the loggers by the given tags. Tags can use the `*` wildcard.
  * @param {'*' | string[]} filter - The filter to set.
  */
  static setFilter(filter) {
    loggingSettings.filter = filter;
  }
  /**
  * Set the format function for the logger.
  * @param {function} func - The function to set.
  */
  static setFormatFunction(func) {
    loggingSettings.formatFunction = func;
  }
  /**
  * Set the function, that joins multiple messages into one for the logger.
  * @param {function} func - The function to set.
  */
  static setMessagesJoinFunction(func) {
    loggingSettings.messagesJoinFunction = func;
  }
  /**
   * Set the tag visibility for the logger. When true, tags will be printed in the log. Disabled by default.
   * @param visible 
   */
  static setTagsOutputVisibility(visible) {
    loggingSettings.outputTags = visible;
  }
  /**
  * Set the JSON formatter for the logger.
  * @param {ColorJSON} formatter - The json formatter to set.
  */
  static setJsonFormatter(formatter) {
    loggingSettings.jsonFormatter = formatter;
  }
  /**
   * Get the output configuration for the logger.
   * @returns {OutputConfig} The output configuration.
   */
  static getOutputConfig() {
    return loggingSettings.outputConfig;
  }
  /**
  * Returns a new Logger.
  *
  * @param {string} name - The name of the Logger.
  * @param {string[]} tags - The tags for the Logger as strings.
  *
  * @returns {Logger} A new Logger.
  */
  static getLogger(name, ...tags) {
    LOGGING: {
      if (!_a4.initialized) {
        _a4.init();
      }
    }
    return new _a4(name, tags);
  }
  /**
  * Log messages with the level set.
  *
  * @param {LogLevel} level - The LogLevel to log the messages at.
  * @param {array} message - An array of the messages to log.
  */
  log(level, ...message) {
    LOGGING: {
      if (level.level < loggingSettings.level.level)
        return;
      if (loggingSettings.filter.length === 0 || this.tags.length === 0) {
        this.logRaw(level, ...message);
        return;
      }
      for (const filter of loggingSettings.filter) {
        if (starMatch(filter, this.name)) {
          this.logRaw(level, ...message);
          return;
        }
      }
    }
  }
  /**
  * Internal function to log messages with the level set, that bypasses the filters.
  *
  * @param {LogLevel} level - The LogLevel to log the messages at.
  * @param {array} message - An array of the messages to log.
  */
  logRaw(level, ...message) {
    LOGGING: {
      const msgs = message.map((x) => {
        if (x === void 0) {
          return ChatColor.GOLD + "undefined" + ChatColor.RESET;
        }
        if (x === null) {
          return ChatColor.GOLD + "null" + ChatColor.RESET;
        }
        if (x && x instanceof Error) {
          return `${ChatColor.DARK_RED}${ChatColor.BOLD}${x.message}
${ChatColor.RESET}${ChatColor.GRAY}${ChatColor.ITALIC}${x.stack}${ChatColor.RESET}`;
        }
        if (typeof x === "object" || Array.isArray(x)) {
          return loggingSettings.jsonFormatter.stringify(x) + ChatColor.RESET;
        }
        return x.toString() + ChatColor.RESET;
      });
      const formatted = loggingSettings.formatFunction(level, this, loggingSettings.messagesJoinFunction(msgs), loggingSettings.outputTags ? this.tags : void 0);
      const outputs = loggingSettings.outputConfig[level.level] || [
        0,
        1
        /* ConsoleInfo */
      ];
      if (outputs.includes(
        0
        /* Chat */
      )) {
        world2.sendMessage(formatted);
      }
      if (outputs.includes(
        1
        /* ConsoleInfo */
      )) {
        if (console.originalLog) {
          console.originalLog(ChatColor.stripColor(formatted));
        } else {
          console.log(ChatColor.stripColor(formatted));
        }
      }
      if (outputs.includes(
        2
        /* ConsoleWarn */
      )) {
        console.warn(formatted);
      }
      if (outputs.includes(
        3
        /* ConsoleError */
      )) {
        console.error(formatted);
      }
    }
  }
  /**
   * Logs a trace message.
   *
   * @param {...unknown} message - The message(s) to be logged.
   */
  trace(...message) {
    LOGGING:
      this.log(LogLevel.Trace, ...message);
  }
  /**
   * Logs debug message.
   *
   * @param {...unknown[]} message - The message(s) to be logged.
   */
  debug(...message) {
    LOGGING:
      this.log(LogLevel.Debug, ...message);
  }
  /**
   * Logs an informational message.
   *
   * @param {...unknown[]} message - The message(s) to be logged.
   */
  info(...message) {
    LOGGING:
      this.log(LogLevel.Info, ...message);
  }
  /**
   * Logs a warning message.
   *
   * @param {...unknown[]} message - The warning message or messages to be logged.
   */
  warn(...message) {
    LOGGING:
      this.log(LogLevel.Warn, ...message);
  }
  /**
   * Logs an error message.
   *
   * @param {...unknown[]} message - The error message(s) to log.
   */
  error(...message) {
    LOGGING:
      this.log(LogLevel.Error, ...message);
  }
  /**
   * Logs a fatal error.
   *
   * @param {unknown[]} message - The error message to log.
   */
  fatal(...message) {
    LOGGING:
      this.log(LogLevel.Fatal, ...message);
  }
}, __publicField(_a4, "initialized", false), _a4);
var _a5;
var Vec3 = (_a5 = class {
  constructor(x, y, z) {
    __publicField(this, "x");
    __publicField(this, "y");
    __publicField(this, "z");
    if (x === Direction.Down) {
      this.x = 0;
      this.y = -1;
      this.z = 0;
    } else if (x === Direction.Up) {
      this.x = 0;
      this.y = 1;
      this.z = 0;
    } else if (x === Direction.North) {
      this.x = 0;
      this.y = 0;
      this.z = 1;
    } else if (x === Direction.South) {
      this.x = 0;
      this.y = 0;
      this.z = -1;
    } else if (x === Direction.East) {
      this.x = 1;
      this.y = 0;
      this.z = 0;
    } else if (x === Direction.West) {
      this.x = -1;
      this.y = 0;
      this.z = 0;
    } else if (typeof x === "number") {
      this.x = x;
      this.y = y;
      this.z = z;
    } else if (Array.isArray(x)) {
      this.x = x[0];
      this.y = x[1];
      this.z = x[2];
    } else if (x instanceof _a5) {
      this.x = x.x;
      this.y = x.y;
      this.z = x.z;
    } else {
      if (!x || !x.x && x.x !== 0 || !x.y && x.y !== 0 || !x.z && x.z !== 0) {
        _a5.log.error(new Error("Invalid vector"), x);
        throw new Error("Invalid vector");
      }
      this.x = x.x;
      this.y = x.y;
      this.z = x.z;
    }
  }
  static from(x, y, z) {
    if (x instanceof _a5)
      return x;
    if (typeof x === "number" && y !== void 0 && z !== void 0) {
      return new _a5(x, y, z);
    }
    if (Array.isArray(x)) {
      return new _a5(x);
    }
    if (x === Direction.Down)
      return _a5.Down;
    if (x === Direction.Up)
      return _a5.Up;
    if (x === Direction.North)
      return _a5.North;
    if (x === Direction.South)
      return _a5.South;
    if (x === Direction.East)
      return _a5.East;
    if (x === Direction.West)
      return _a5.West;
    if (!x || !x.x && x.x !== 0 || !x.y && x.y !== 0 || !x.z && x.z !== 0) {
      _a5.log.error(new Error("Invalid arguments"), x, y, z);
      throw new Error("Invalid arguments");
    }
    return new _a5(x.x, x.y, x.z);
  }
  static _from(x, y, z) {
    if (x instanceof _a5)
      return x;
    if (typeof x === "number" && y !== void 0 && z !== void 0) {
      return new _a5(x, y, z);
    }
    if (Array.isArray(x)) {
      return new _a5(x);
    }
    if (x === Direction.Down)
      return _a5.Down;
    if (x === Direction.Up)
      return _a5.Up;
    if (x === Direction.North)
      return _a5.North;
    if (x === Direction.South)
      return _a5.South;
    if (x === Direction.East)
      return _a5.East;
    if (x === Direction.West)
      return _a5.West;
    if (!x || !x.x && x.x !== 0 || !x.y && x.y !== 0 || !x.z && x.z !== 0) {
      _a5.log.error(new Error("Invalid arguments"), x, y, z);
      throw new Error("Invalid arguments");
    }
    return new _a5(x.x, x.y, x.z);
  }
  /**
   * Creates a copy of the current vector.
   * 
   * @returns A new vector with the same values as the current vector.
   */
  copy() {
    return _a5.from(this);
  }
  static fromYawPitch(yawOrRotation, pitch) {
    let yaw;
    if (typeof yawOrRotation === "number") {
      yaw = yawOrRotation;
      pitch = pitch;
    } else {
      yaw = yawOrRotation.y;
      pitch = yawOrRotation.x;
    }
    const psi = yaw * (Math.PI / 180);
    const theta = pitch * (Math.PI / 180);
    const x = Math.cos(theta) * Math.sin(psi);
    const y = Math.sin(theta);
    const z = Math.cos(theta) * Math.cos(psi);
    return new _a5(x, y, z);
  }
  /**
   * Converts the normal vector to yaw and pitch values.
   * 
   * @returns A Vector2 containing the yaw and pitch values.
   */
  toYawPitch() {
    if (this.isZero()) {
      _a5.log.error(new Error("Cannot convert zero-length vector to direction"));
      throw new Error("Cannot convert zero-length vector to direction");
    }
    const direction = this.normalize();
    const yaw = Math.atan2(direction.x, direction.z) * (180 / Math.PI);
    const pitch = Math.asin(direction.y) * (180 / Math.PI);
    return {
      x: pitch,
      y: yaw
    };
  }
  add(x, y, z) {
    const v = _a5._from(x, y, z);
    return _a5.from(v.x + this.x, v.y + this.y, v.z + this.z);
  }
  subtract(x, y, z) {
    const v = _a5._from(x, y, z);
    return _a5.from(this.x - v.x, this.y - v.y, this.z - v.z);
  }
  multiply(x, y, z) {
    if (typeof x === "number" && y === void 0 && z === void 0) {
      return _a5.from(this.x * x, this.y * x, this.z * x);
    }
    const v = _a5._from(x, y, z);
    return _a5.from(v.x * this.x, v.y * this.y, v.z * this.z);
  }
  /**
   * Scales the current vector by a scalar.
   *
   * @param v - The scalar to scale by.
   * @returns The updated vector after scaling.
   */
  scale(scalar) {
    return _a5.from(this.x * scalar, this.y * scalar, this.z * scalar);
  }
  divide(x, y, z) {
    if (typeof x === "number" && y === void 0 && z === void 0) {
      if (x === 0)
        throw new Error("Cannot divide by zero");
      return _a5.from(this.x / x, this.y / x, this.z / x);
    }
    const v = _a5._from(x, y, z);
    if (v.x === 0 || v.y === 0 || v.z === 0)
      throw new Error("Cannot divide by zero");
    return _a5.from(this.x / v.x, this.y / v.y, this.z / v.z);
  }
  /**
   * Normalizes the vector to have a length (magnitude) of 1.
   * Normalized vectors are often used as a direction vectors.
   *
   * @returns The normalized vector.
   */
  normalize() {
    if (this.isZero()) {
      _a5.log.error(new Error("Cannot normalize zero-length vector"));
      throw new Error("Cannot normalize zero-length vector");
    }
    const len = this.length();
    return _a5.from(this.x / len, this.y / len, this.z / len);
  }
  /**
   * Computes the length (magnitude) of the vector.
   *
   * @returns The length of the vector.
   */
  length() {
    return Math.sqrt(this.lengthSquared());
  }
  /**
   * Computes the squared length of the vector.
   * This is faster than computing the actual length and can be useful for comparison purposes.
   *
   * @returns The squared length of the vector.
   */
  lengthSquared() {
    return this.x * this.x + this.y * this.y + this.z * this.z;
  }
  cross(x, y, z) {
    const v = _a5._from(x, y, z);
    return _a5.from(
      this.y * v.z - this.z * v.y,
      this.z * v.x - this.x * v.z,
      this.x * v.y - this.y * v.x
    );
  }
  distance(x, y, z) {
    const v = _a5._from(x, y, z);
    return Math.sqrt(this.distanceSquared(v));
  }
  distanceSquared(x, y, z) {
    const v = _a5._from(x, y, z);
    return this.subtract(v).lengthSquared();
  }
  /**
   * Computes the linear interpolation between the current vector and another vector, when t is in the range [0, 1].
   * Computes the extrapolation when t is outside this range.
   *
   * @param v - The other vector.
   * @param t - The interpolation factor.
   * @returns A new vector after performing the lerp operation.
   */
  lerp(v, t) {
    if (!v || !t)
      return _a5.from(this);
    if (t === 1)
      return _a5.from(v);
    if (t === 0)
      return _a5.from(this);
    return _a5.from(
      this.x + (v.x - this.x) * t,
      this.y + (v.y - this.y) * t,
      this.z + (v.z - this.z) * t
    );
  }
  /**
   * Computes the spherical linear interpolation between the current vector and another vector, when t is in the range [0, 1].
   * Computes the extrapolation when t is outside this range.
   *
   * @param v - The other vector.
   * @param t - The interpolation factor.
   * @returns A new vector after performing the slerp operation.
   */
  slerp(v, t) {
    if (!v || !t)
      return _a5.from(this);
    if (t === 1)
      return _a5.from(v);
    if (t === 0)
      return _a5.from(this);
    const dot = this.dot(v);
    const theta = Math.acos(dot) * t;
    const relative = _a5.from(v).subtract(this.multiply(dot)).normalize();
    return this.multiply(Math.cos(theta)).add(relative.multiply(Math.sin(theta)));
  }
  dot(x, y, z) {
    const v = _a5._from(x, y, z);
    return this.x * v.x + this.y * v.y + this.z * v.z;
  }
  angleBetween(x, y, z) {
    const v = _a5._from(x, y, z);
    const dotProduct = this.dot(v);
    const lengths = this.length() * v.length();
    if (lengths === 0) {
      return 0;
    }
    return Math.acos(dotProduct / lengths);
  }
  projectOnto(x, y, z) {
    const v = _a5._from(x, y, z);
    if (v.isZero()) {
      return _a5.Zero;
    }
    const scale = this.dot(v) / v.dot(v);
    return _a5.from(v.x * scale, v.y * scale, v.z * scale);
  }
  reflect(x, y, z) {
    const normal = _a5._from(x, y, z);
    const proj = this.projectOnto(normal);
    return this.subtract(proj.multiply(2));
  }
  /**
   * Rotates the current normalized vector by a given angle around a given axis.
   * 
   * @param axis - The axis of rotation.
   * @param angle - The angle of rotation in degrees.
   * @returns The rotated vector.
   */
  rotate(axis, angle) {
    const halfAngle = angle * Math.PI / 180 / 2;
    const w = Math.cos(halfAngle);
    const x = axis.x * Math.sin(halfAngle);
    const y = axis.y * Math.sin(halfAngle);
    const z = axis.z * Math.sin(halfAngle);
    const v = this;
    const qv_x = w * w * v.x + 2 * y * w * v.z - 2 * z * w * v.y + x * x * v.x + 2 * y * x * v.y + 2 * z * x * v.z - z * z * v.x - y * y * v.x;
    const qv_y = 2 * x * y * v.x + y * y * v.y + 2 * z * y * v.z + 2 * w * z * v.x - z * z * v.y + w * w * v.y - 2 * x * w * v.z - x * x * v.y;
    const qv_z = 2 * x * z * v.x + 2 * y * z * v.y + z * z * v.z - 2 * w * y * v.x - y * y * v.z + 2 * w * x * v.y - x * x * v.z + w * w * v.z;
    return new _a5(qv_x, qv_y, qv_z);
  }
  /**
   * Sets the X component of the vector.
   *
   * @param value - The new X value.
   * @returns The updated vector with the new X value.
   */
  setX(value) {
    return new _a5(value, this.y, this.z);
  }
  /**
   * Sets the Y component of the vector.
   *
   * @param value - The new Y value.
   * @returns The updated vector with the new Y value.
   */
  setY(value) {
    return new _a5(this.x, value, this.z);
  }
  /**
   * Sets the Z component of the vector.
   *
   * @param value - The new Z value.
   * @returns The updated vector with the new Z value.
   */
  setZ(value) {
    return new _a5(this.x, this.y, value);
  }
  /**
   * Calculates the shortest distance between a point (represented by this Vector3 instance) and a line segment.
   * 
   * This method finds the perpendicular projection of the point onto the line defined by the segment. If this 
   * projection lies outside the line segment, then the method calculates the distance from the point to the 
   * nearest segment endpoint.
   * 
   * @param start - The starting point of the line segment.
   * @param end - The ending point of the line segment.
   * @returns The shortest distance between the point and the line segment.
   */
  distanceToLineSegment(start, end) {
    const lineDirection = _a5.from(end).subtract(start);
    if (lineDirection.lengthSquared() === 0) {
      return this.subtract(start).length();
    }
    const t = Math.max(0, Math.min(1, this.subtract(start).dot(lineDirection) / lineDirection.dot(lineDirection)));
    const projection = _a5.from(start).add(lineDirection.multiply(t));
    return this.subtract(projection).length();
  }
  /**
   * Floors the X, Y, and Z components of the vector.
   * @returns A new vector with the floored components.
   */
  floor() {
    return new _a5(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
  }
  /**
   * Floors the X component of the vector.
   * @returns A new vector with the floored X component.
   */
  floorX() {
    return new _a5(Math.floor(this.x), this.y, this.z);
  }
  /**
   * Floors the Y component of the vector.
   * @returns A new vector with the floored Y component.
   */
  floorY() {
    return new _a5(this.x, Math.floor(this.y), this.z);
  }
  /**
   * Floors the Z component of the vector.
   * @returns A new vector with the floored Z component.
   */
  floorZ() {
    return new _a5(this.x, this.y, Math.floor(this.z));
  }
  /**
   * Ceils the X, Y, and Z components of the vector.
   * @returns A new vector with the ceiled components.
   */
  ceil() {
    return new _a5(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
  }
  /**
   * Ceils the X component of the vector.
   * @returns A new vector with the ceiled X component.
   */
  ceilX() {
    return new _a5(Math.ceil(this.x), this.y, this.z);
  }
  /**
   * Ceils the Y component of the vector.
   * @returns A new vector with the ceiled Y component.
   */
  ceilY() {
    return new _a5(this.x, Math.ceil(this.y), this.z);
  }
  /**
   * Ceils the Z component of the vector.
   * @returns A new vector with the ceiled Z component.
   */
  ceilZ() {
    return new _a5(this.x, this.y, Math.ceil(this.z));
  }
  /**
   * Rounds the X, Y, and Z components of the vector.
   * @returns A new vector with the rounded components.
   */
  round() {
    return new _a5(Math.round(this.x), Math.round(this.y), Math.round(this.z));
  }
  /**
   * Rounds the X component of the vector.
   * @returns A new vector with the rounded X component.
   */
  roundX() {
    return new _a5(Math.round(this.x), this.y, this.z);
  }
  /**
   * Rounds the Y component of the vector.
   * @returns A new vector with the rounded Y component.
   */
  roundY() {
    return new _a5(this.x, Math.round(this.y), this.z);
  }
  /**
   * Rounds the Z component of the vector.
   * @returns A new vector with the rounded Z component.
   */
  roundZ() {
    return new _a5(this.x, this.y, Math.round(this.z));
  }
  /**
   * Returns a new vector offset from the current vector up by 1 block.
   * @returns A new vector offset from the current vector up by 1 block.
   */
  up() {
    return this.add(_a5.Up);
  }
  /**
   * Returns a new vector offset from the current vector down by 1 block.
   * @returns A new vector offset from the current vector down by 1 block.
   */
  down() {
    return this.add(_a5.Down);
  }
  /**
   * Returns a new vector offset from the current vector north by 1 block.
   * @returns A new vector offset from the current vector north by 1 block.
   */
  north() {
    return this.add(_a5.North);
  }
  /**
   * Returns a new vector offset from the current vector south by 1 block.
   * @returns A new vector offset from the current vector south by 1 block.
   */
  south() {
    return this.add(_a5.South);
  }
  /**
   * Returns a new vector offset from the current vector east by 1 block.
   * @returns A new vector offset from the current vector east by 1 block.
   */
  east() {
    return this.add(_a5.East);
  }
  /**
   * Returns a new vector offset from the current vector west by 1 block.
   * @returns A new vector offset from the current vector west by 1 block.
   */
  west() {
    return this.add(_a5.West);
  }
  /**
   * Checks if the current vector is equal to the zero vector.
   * @returns true if the vector is equal to the zero vector, else returns false.
   */
  isZero() {
    return this.x === 0 && this.y === 0 && this.z === 0;
  }
  /**
   * Converts the vector to an array containing the X, Y, and Z components of the vector.
   * @returns An array containing the X, Y, and Z components of the vector.
   */
  toArray() {
    return [this.x, this.y, this.z];
  }
  /**
   * Converts the vector to a direction.
   * If the vector is not a unit vector, then it will be normalized and rounded to the nearest direction.
   */
  toDirection() {
    if (this.isZero()) {
      _a5.log.error(new Error("Cannot convert zero-length vector to direction"));
      throw new Error("Cannot convert zero-length vector to direction");
    }
    const normalized = this.normalize();
    const maxValue = Math.max(Math.abs(normalized.x), Math.abs(normalized.y), Math.abs(normalized.z));
    if (maxValue === normalized.x)
      return Direction.East;
    if (maxValue === -normalized.x)
      return Direction.West;
    if (maxValue === normalized.y)
      return Direction.Up;
    if (maxValue === -normalized.y)
      return Direction.Down;
    if (maxValue === normalized.z)
      return Direction.North;
    if (maxValue === -normalized.z)
      return Direction.South;
    _a5.log.error(new Error("Cannot convert vector to direction"), this);
    throw new Error("Cannot convert vector to direction");
  }
  /**
   * Returns a new vector with the X, Y, and Z components rounded to the nearest block location.
   */
  toBlockLocation() {
    return _a5.from(
      (this.x << 0) - (this.x < 0 && this.x !== this.x << 0 ? 1 : 0),
      (this.y << 0) - (this.y < 0 && this.y !== this.y << 0 ? 1 : 0),
      (this.z << 0) - (this.z < 0 && this.z !== this.z << 0 ? 1 : 0)
    );
  }
  almostEqual(x, y, z, delta) {
    try {
      let other;
      if (typeof x !== "number" && z === void 0) {
        other = _a5._from(x, void 0, void 0);
        delta = y;
      } else {
        other = _a5._from(x, y, z);
      }
      return Math.abs(this.x - other.x) <= delta && Math.abs(this.y - other.y) <= delta && Math.abs(this.z - other.z) <= delta;
    } catch (e) {
      return false;
    }
  }
  equals(x, y, z) {
    try {
      const other = _a5._from(x, y, z);
      return this.x === other.x && this.y === other.y && this.z === other.z;
    } catch (e) {
      return false;
    }
  }
  toString(format = "long", separator = ", ") {
    const result = `${this.x + separator + this.y + separator + this.z}`;
    return format === "long" ? `Vec3(${result})` : result;
  }
}, __publicField(_a5, "log", Logger.getLogger("vec3", "vec3", "bedrock-boost")), __publicField(_a5, "Zero", new _a5(0, 0, 0)), __publicField(_a5, "Down", new _a5(Direction.Down)), __publicField(_a5, "Up", new _a5(Direction.Up)), __publicField(_a5, "North", new _a5(Direction.North)), __publicField(_a5, "South", new _a5(Direction.South)), __publicField(_a5, "East", new _a5(Direction.East)), __publicField(_a5, "West", new _a5(Direction.West)), _a5);
var _a6;
var Timings = (_a6 = class {
  /**
   * Begin measuring the time it takes to perform an operation.
   * @remarks
   * If another operation is already being measured, the measurement will be ended.
   * 
   * @param operation The name of the operation.
   */
  static begin(operation) {
    this.end();
    this.lastTime = (/* @__PURE__ */ new Date()).getTime();
    this.lastOperation = operation;
  }
  /**
   * End measuring the time it takes to perform an operation and log the result.
   * @remarks
   * If no operation is being measured, this method will do nothing.
   */
  static end() {
    const time = (/* @__PURE__ */ new Date()).getTime();
    if (this.lastTime > 0) {
      _a6.log.debug(`Operation ${this.lastOperation} took ${time - this.lastTime}ms`);
    }
    this.lastTime = -1;
  }
}, __publicField(_a6, "log", Logger.getLogger("Timings", "timings")), __publicField(_a6, "lastTime", -1), __publicField(_a6, "lastOperation", ""), _a6);
var log = Logger.getLogger("jobUtils", "bedrock-boost", "jobUtils");
var log2 = Logger.getLogger("itemUtils", "bedrock-boost", "itemUtils");
var _a7;
var PulseScheduler = (_a7 = class {
  /**
   * Creates a new PulseScheduler instance.
   * @param period The period of the scheduler.
   */
  constructor(processor, period) {
    __publicField(this, "items", []);
    __publicField(this, "period");
    __publicField(this, "currentTick", 0);
    __publicField(this, "runId");
    __publicField(this, "nextIndex", 0);
    __publicField(this, "executionSchedule", []);
    __publicField(this, "processor");
    if (period <= 0) {
      throw new Error("Period must be a positive integer.");
    }
    if (!processor || typeof processor !== "function") {
      throw new Error("Processor function must be defined.");
    }
    this.period = period;
    this.processor = processor;
  }
  /**
   * Adds an item to the schedule.
   * @param item The item to be added.
   * @deprecated Use `push` instead.
   */
  add(item) {
    this.push(item);
  }
  /**
    * Adds multiple items to the schedule.
    * 
    * @param items - The items to be added.
    * @deprecated Use `push` instead.
    */
  addAll(items) {
    this.push(...items);
  }
  /**
   * Removes an item from the schedule at the specified index.
   * @param index - The index of the item to remove.
   */
  remove(index) {
    if (index >= 0 && index < this.items.length) {
      this.items.splice(index, 1);
      if (index < this.nextIndex) {
        this.nextIndex--;
      }
      this.recalculateExecutionSchedule();
    }
  }
  /**
   * Removes items from the schedule that satisfy the given predicate.
   * 
   * @param predicate - The predicate function used to determine if an item should be removed.
   */
  removeIf(predicate) {
    for (let i = this.items.length - 1; i >= 0; i--) {
      if (predicate(this.items[i])) {
        this.remove(i);
      }
    }
  }
  /**
   * Returns a list of the items in the schedule.
   */
  getItems() {
    return this.items;
  }
  /**
   * Starts the schedule.
   */
  start() {
    this.stop();
    this.currentTick = 0;
    this.nextIndex = 0;
    this.runId = system4.runInterval(() => this.tick(), 1);
  }
  /**
   * Stops the schedule.
   */
  stop() {
    if (this.runId !== void 0) {
      system4.clearRun(this.runId);
      this.runId = void 0;
    }
  }
  recalculateExecutionSchedule() {
    const totalExecutions = this.items.length;
    this.executionSchedule = new Array(this.period).fill(0);
    if (totalExecutions === 0) {
      return;
    }
    const interval = this.period / totalExecutions;
    for (let i = 0; i < totalExecutions; i++) {
      this.executionSchedule[Math.round(interval * i) % this.period]++;
    }
  }
  tick() {
    if (this.items.length === 0) {
      _a7.log.trace("No items to process.");
      return;
    }
    const scheduledExecutions = this.executionSchedule[this.currentTick];
    if (scheduledExecutions === 0) {
      _a7.log.trace("No items to process this tick.");
      this.currentTick = (this.currentTick + 1) % this.period;
      if (this.currentTick === 0) {
        this.nextIndex = 0;
      }
      return;
    }
    let executed = 0;
    for (; this.nextIndex < this.items.length && executed < scheduledExecutions; this.nextIndex++) {
      try {
        this.processor(this.items[this.nextIndex]);
      } catch (e) {
        _a7.log.error("Error processing item", e);
      }
      executed++;
    }
    this.currentTick = (this.currentTick + 1) % this.period;
    if (this.currentTick === 0) {
      this.nextIndex = 0;
    }
  }
  push(...items) {
    this.items.push(...items);
    this.recalculateExecutionSchedule();
    return this.items.length;
  }
  pop() {
    const item = this.items.pop();
    this.recalculateExecutionSchedule();
    return item;
  }
  shift() {
    const item = this.items.shift();
    this.recalculateExecutionSchedule();
    return item;
  }
  unshift(...items) {
    this.items.unshift(...items);
    this.recalculateExecutionSchedule();
    return this.items.length;
  }
  splice(start, deleteCount = 0, ...items) {
    const removed = this.items.splice(start, deleteCount, ...items);
    this.recalculateExecutionSchedule();
    return removed;
  }
}, __publicField(_a7, "log", Logger.getLogger("PulseScheduler", "bedrock-boost", "pulse-scheduler")), _a7);
var _a8;
var PlayerPulseScheduler = (_a8 = class extends PulseScheduler {
  /**
   * Creates a new EntityPulseScheduler instance.
   * @param period The period of the scheduler.
   * @param queryOptions The query options to use when querying for entities.
   */
  constructor(processor, period) {
    super((t) => {
      if (t.isValid()) {
        processor(t);
      } else {
        this.removeIf((entity) => !entity.isValid());
      }
    }, period);
    this.push(...world5.getAllPlayers());
  }
  compareEntities(a, b) {
    return a.id === b.id;
  }
  start() {
    world5.afterEvents.playerJoin.subscribe((event) => {
      let attempts = 0;
      const pushPlayer = () => {
        attempts++;
        if (attempts > 10) {
          _a8.logger.warn("Failed to push player to scheduler after 10 attempts.");
          return;
        }
        try {
          const player = world5.getEntity(event.playerId);
          if (player === void 0) {
            system5.runTimeout(pushPlayer, 1);
          }
          if (player instanceof Player3) {
            this.push(player);
          }
        } catch (e) {
          _a8.logger.debug("Failed to push player to scheduler.", e);
          system5.runTimeout(pushPlayer, 1);
        }
      };
      pushPlayer();
    });
    world5.afterEvents.playerLeave.subscribe((event) => {
      this.removeIf((entity) => !entity.isValid() || entity.id === event.playerId);
    });
    super.start();
  }
  push(...items) {
    const filtered = items.filter((item) => item.isValid() && !this.items.some((existingItem) => this.compareEntities(existingItem, item)));
    return super.push(...filtered);
  }
  unshift(...items) {
    const filtered = items.filter((item) => item.isValid() && !this.items.some((existingItem) => this.compareEntities(existingItem, item)));
    return super.unshift(...filtered);
  }
  splice(start, deleteCount, ...items) {
    if (deleteCount === void 0) {
      return super.splice(start);
    }
    const filtered = items.filter((item) => !this.items.some((existingItem) => this.compareEntities(existingItem, item)));
    return super.splice(start, deleteCount, ...filtered);
  }
}, __publicField(_a8, "logger", Logger.getLogger("PlayerPulseScheduler", "bedrock-boost", "player-pulse-scheduler")), _a8);

// data/system_template_esbuild/subscripts/guide_book_page_access.ts
import { world as world6 } from "@minecraft/server";
var bookName = "guide_book";
var pageIdxGroupIdxAndGroupItemIdx = [[15, 0], [8, 0], [4, 0], [9, 0], [14, 0], [13, 0], [19, 0], [16, 0], [17, 0], [18, 0], [2, 0], [7, 0], [23, 0], [6, 0], [24, 0], [1, 0], [5, 0], [10, 0], [3, 0], [22, 0], [21, 0], [12, 0], [0, 0], [11, 0], [20, 0]];
var groupIdxGroupName = ["0023page", "0016page", "0011page", "0019page", "0003page", "0017page", "0014page", "0012page", "0002page", "0004page", "0018page", "0024page", "0022page", "0006page", "0005page", "0001page", "0008page", "0009page", "0010page", "0007page", "0025page", "0021page", "0020page", "0013page", "0015page"];
var groupInfo = { "0023page": [{ "page_index": 22, "group_index": 0, "group_name": "0023page" }], "0016page": [{ "page_index": 15, "group_index": 1, "group_name": "0016page" }], "0011page": [{ "page_index": 10, "group_index": 2, "group_name": "0011page" }], "0019page": [{ "page_index": 18, "group_index": 3, "group_name": "0019page" }], "0003page": [{ "page_index": 2, "group_index": 4, "group_name": "0003page" }], "0017page": [{ "page_index": 16, "group_index": 5, "group_name": "0017page" }], "0014page": [{ "page_index": 13, "group_index": 6, "group_name": "0014page" }], "0012page": [{ "page_index": 11, "group_index": 7, "group_name": "0012page" }], "0002page": [{ "page_index": 1, "group_index": 8, "group_name": "0002page" }], "0004page": [{ "page_index": 3, "group_index": 9, "group_name": "0004page" }], "0018page": [{ "page_index": 17, "group_index": 10, "group_name": "0018page" }], "0024page": [{ "page_index": 23, "group_index": 11, "group_name": "0024page" }], "0022page": [{ "page_index": 21, "group_index": 12, "group_name": "0022page" }], "0006page": [{ "page_index": 5, "group_index": 13, "group_name": "0006page" }], "0005page": [{ "page_index": 4, "group_index": 14, "group_name": "0005page" }], "0001page": [{ "page_index": 0, "group_index": 15, "group_name": "0001page" }], "0008page": [{ "page_index": 7, "group_index": 16, "group_name": "0008page" }], "0009page": [{ "page_index": 8, "group_index": 17, "group_name": "0009page" }], "0010page": [{ "page_index": 9, "group_index": 18, "group_name": "0010page" }], "0007page": [{ "page_index": 6, "group_index": 19, "group_name": "0007page" }], "0025page": [{ "page_index": 24, "group_index": 20, "group_name": "0025page" }], "0021page": [{ "page_index": 20, "group_index": 21, "group_name": "0021page" }], "0020page": [{ "page_index": 19, "group_index": 22, "group_name": "0020page" }], "0013page": [{ "page_index": 12, "group_index": 23, "group_name": "0013page" }], "0015page": [{ "page_index": 14, "group_index": 24, "group_name": "0015page" }] };
var pageInteractions = [{ "min": [-0.8, -0.6], "max": [0, 0.45], "responses": [{ "type": "previous_page_group", "wrap": true }, { "type": "run_command", "as": "book", "command": "/title @a actionbar PREVIOUS PAGE" }, { "type": "run_command", "as": "book", "command": "/particle shapescape_sdi:click" }] }, { "min": [0, -0.6], "max": [0.8, 0.45], "responses": [{ "type": "next_page_group", "wrap": true }, { "type": "run_command", "as": "book", "command": "/title @a actionbar NEXT PAGE" }, { "type": "run_command", "as": "book", "command": "/particle shapescape_sdi:click" }] }];
function getGroupInfo(groupName) {
  const group = groupInfo[groupName];
  if (!Array.isArray(group)) {
    return void 0;
  }
  return group;
}
function getGroupName(entity) {
  const index = entity.getProperty("shapescape_sdi:active_texture")?.valueOf();
  if (typeof index != "number") {
    return void 0;
  }
  const [groupIdx, pageIdx] = pageIdxGroupIdxAndGroupItemIdx[index];
  return [groupIdxGroupName[groupIdx], pageIdx];
}
function setGroup(entity, groupName) {
  const group = getGroupInfo(groupName);
  if (group == void 0) {
    return;
  }
  if (group.length == 1) {
    entity.setProperty("shapescape_sdi:active_texture", group[0].page_index);
    return;
  }
  entity.runCommand(`function ${bookName}/get_${groupName}_state_value`);
  const stateIdx = world6.scoreboard.getObjective("shapescape_sdi_tmp_var")?.getScore("STATE")?.valueOf();
  if (typeof stateIdx != "number") {
    return;
  }
  entity.setProperty("shapescape_sdi:active_texture", group[stateIdx].page_index);
}
function setNextGroup(entity, wrap) {
  const groupNameAndPageIndex = getGroupName(entity);
  if (groupNameAndPageIndex == void 0) {
    return;
  }
  const groupName = groupNameAndPageIndex[0];
  const group = getGroupInfo(groupName);
  if (group == void 0) {
    return;
  }
  let nextGroupIdx = group[0].group_index + 1;
  if (nextGroupIdx >= groupIdxGroupName.length) {
    nextGroupIdx = 0;
  }
  setGroup(entity, groupIdxGroupName[nextGroupIdx]);
}
function setPreviousGroup(entity, wrap) {
  const groupNameAndPageIndex = getGroupName(entity);
  if (groupNameAndPageIndex == void 0) {
    return;
  }
  const groupName = groupNameAndPageIndex[0];
  const group = getGroupInfo(groupName);
  if (group == void 0) {
    return;
  }
  let prevGroupIdx = group[0].group_index - 1;
  if (prevGroupIdx < 0) {
    prevGroupIdx = groupIdxGroupName.length - 1;
  }
  setGroup(entity, groupIdxGroupName[prevGroupIdx]);
}
function runPageInteraction(entity, player, x, y, interactionPoint) {
  const group = getGroupName(entity);
  if (group == void 0) {
    return;
  }
  const [groupName, pageIndex] = group;
  for (const pageInteraction of pageInteractions) {
    const [minX, minY] = pageInteraction.min;
    const [maxX, maxY] = pageInteraction.max;
    if (pageInteraction.group_name != void 0 && pageInteraction.group_name != groupName) {
      continue;
    }
    if (pageInteraction.group_item_index != void 0 && pageInteraction.group_item_index != pageIndex) {
      continue;
    }
    if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
      for (const event of pageInteraction.responses) {
        switch (event.type) {
          case "previous_page_group":
            setPreviousGroup(entity, event.wrap ?? false);
            break;
          case "next_page_group":
            setNextGroup(entity, event.wrap ?? false);
            break;
          case "run_command":
            let { x: ipx, y: ipy, z: ipz } = interactionPoint;
            ipx = Math.round(ipx * 100) / 100;
            ipy = Math.round(ipy * 100) / 100;
            ipz = Math.round(ipz * 100) / 100;
            if (event.as == "book") {
              const command = `execute positioned ${ipx} ${ipy} ${ipz} run ${event.command}`;
              entity.runCommand(command);
            } else {
              const command = `execute positioned ${ipx} ${ipy} ${ipz} run ${event.command}`;
              player.runCommand(command);
            }
            break;
          case "set_page_group":
            setGroup(entity, event.group_name);
            break;
        }
      }
      if (pageInteraction.break) {
        break;
      }
    }
  }
}

// data/system_template_esbuild/subscripts/guide_book_coordinates.ts
var Cartesian3D = class {
  /**
   * Creates a new Cartesian3D coordinate system
   * @param origin the origin point of the coordinate system
   * @param x the x-axis of the coordinate system
   * @param y the y-axis of the coordinate system (must be perpendicular to x)
   */
  constructor(origin, x, y) {
    __publicField(this, "origin");
    __publicField(this, "x");
    __publicField(this, "y");
    __publicField(this, "z");
    x = x.normalize();
    y = y.normalize();
    if (Math.abs(x.dot(y)) > 1e-5) {
      throw new Error("X and Y are not perpendicular");
    }
    this.origin = origin;
    this.x = x.normalize();
    this.y = y.normalize();
    this.z = x.cross(y).normalize();
  }
  /**
   * Converts a point from the coordinate system of this object to another
   * coordinate system
   * @param point a point expressed in the coordinate system of this object
   * @param otherCoordinates a target coordinate system to convert the
   * point to.
   * @returns coordinates of the point in the target coordinate system
   */
  convertToOtherCoordinates(point, otherCoordinates) {
    let originTranslation = point.subtract(otherCoordinates.origin);
    let xLocal = originTranslation.dot(otherCoordinates.x);
    let yLocal = originTranslation.dot(otherCoordinates.y);
    let zLocal = originTranslation.dot(otherCoordinates.z);
    let newPointX = this.x.multiply(xLocal);
    let newPointY = this.y.multiply(yLocal);
    let newPointZ = this.z.multiply(zLocal);
    let newPoint = newPointX.add(newPointY).add(newPointZ);
    return newPoint.add(this.origin);
  }
};
var globalCartesianSpace = new Cartesian3D(
  Vec3.from(0, 0, 0),
  Vec3.from(1, 0, 0),
  Vec3.from(0, 1, 0)
);
function linePlaneCollisionCoords(lineOrigin, lineDirection, planeOrigin, planeNormal) {
  const pointA = lineOrigin;
  const pointB = lineOrigin.add(lineDirection);
  const pointP = planeOrigin;
  const normal = planeNormal;
  const x1 = pointA.x;
  const y1 = pointA.y;
  const z1 = pointA.z;
  const x2 = pointB.x;
  const y2 = pointB.y;
  const z2 = pointB.z;
  const x0 = pointP.x;
  const y0 = pointP.y;
  const z0 = pointP.z;
  const a = normal.x;
  const b = normal.y;
  const c = normal.z;
  const d = a * x0 + b * y0 + c * z0;
  const denominator = a * (x2 - x1) + b * (y2 - y1) + c * (z2 - z1);
  if (denominator == 0) {
    return void 0;
  }
  const t = (d - a * x1 - b * y1 - c * z1) / denominator;
  const intersection = Vec3.from({
    x: x1 + t * (x2 - x1),
    y: y1 + t * (y2 - y1),
    z: z1 + t * (z2 - z1)
  });
  return intersection;
}

// data/system_template_esbuild/subscripts/guide_book.ts
function getBookInteractionCoordinates(book, player) {
  const bookOrigin = Vec3.from(book.location).add(0, 1.5, 0);
  let sourceEntityDirection = Vec3.from(book.location).subtract(player.location).setY(0).normalize();
  let sourceEntityYaw = Math.atan2(sourceEntityDirection.z, sourceEntityDirection.x) * (180 / Math.PI);
  const bookX = sourceEntityDirection.rotate(Vec3.from(0, 1, 0), -90);
  const bookY = Vec3.from(0, 1, 0).rotate(Vec3.from(0, 0, 1), -22.5).rotate(Vec3.from(0, 1, 0), -sourceEntityYaw);
  const bookZ = bookX.cross(bookY);
  const interactionPoint = linePlaneCollisionCoords(
    Vec3.from(player.getHeadLocation()),
    Vec3.from(player.getViewDirection()),
    bookOrigin,
    bookZ
  );
  if (interactionPoint == void 0) {
    return void 0;
  }
  let bookCartesianSpace;
  try {
    bookCartesianSpace = new Cartesian3D(bookOrigin, bookX, bookY);
  } catch (e) {
    return void 0;
  }
  const bookInteractionPoint = globalCartesianSpace.convertToOtherCoordinates(
    interactionPoint,
    bookCartesianSpace
  );
  if (bookInteractionPoint == void 0) {
    return void 0;
  }
  return { local: bookInteractionPoint, global: interactionPoint };
}
system6.afterEvents.scriptEventReceive.subscribe((event) => {
  if (event.id != `shapescape_sdi:${bookName}_interaction`) {
    return;
  }
  const sourceEntity = event.sourceEntity;
  if (sourceEntity == void 0) {
    return;
  }
  const player = sourceEntity.dimension.getPlayers({
    location: sourceEntity.location,
    closest: 1
  })[0];
  const bookInteractionPoint = getBookInteractionCoordinates(
    sourceEntity,
    player
  );
  if (bookInteractionPoint == void 0) {
    return;
  }
  const { local, global } = bookInteractionPoint;
  runPageInteraction(sourceEntity, player, local.x, local.y, global);
});

// data/system_template_esbuild/subscripts/starting_eq.ts
import { world as world8 } from "@minecraft/server";
var DEBUG2 = false;
var NAMESPACE2 = "shapescape_sdi:";
var TAG2 = "eq";
var PATH_NAMESPACE2 = "shapescape/sdi/";
world8.afterEvents.playerSpawn.subscribe((event) => {
  givePlayerEq(event.player);
});
function givePlayerEq(player) {
  player.runCommand(
    `execute as @s[tag=!${NAMESPACE2.substring(
      0,
      NAMESPACE2.length - 1
    )}_${TAG2}] at @s run loot spawn ~ ~ ~ loot "${PATH_NAMESPACE2}starting_eq"`
  );
  player.runCommand(
    `tag @s[tag=!${NAMESPACE2.substring(
      0,
      NAMESPACE2.length - 1
    )}] add ${NAMESPACE2.substring(0, NAMESPACE2.length - 1)}_${TAG2}`
  );
  if (DEBUG2) {
    world8.sendMessage(`Given Player Eq`);
  }
}

// data/system_template_esbuild/subscripts/force_field.ts
import {
  system as system7
} from "@minecraft/server";
function subtractVectors(start, end) {
  return {
    x: start.x - end.x,
    y: start.y - end.y,
    z: start.z - end.z
  };
}
function getImpulseVector(start, end, power) {
  let vector = subtractVectors(end, start);
  vector.y = 0;
  const length = Math.sqrt(
    vector.x * vector.x + vector.y * vector.y + vector.z * vector.z
  );
  return {
    x: vector.x / length * power + 1.4,
    y: vector.y / length * power + 0.7,
    // Slight upword push
    z: vector.z / length * power + 1.4
  };
}
system7.afterEvents.scriptEventReceive.subscribe((event) => {
  if (event.id !== "shapescape_sdi:force_field_module_push") {
    return;
  }
  const sourceEntity = event.sourceEntity;
  if (sourceEntity === void 0) {
    return;
  }
  for (const entity of sourceEntity.dimension.getEntities({
    excludeFamilies: ["player", "inanimate", "game"],
    excludeTypes: ["minecraft:item"],
    location: sourceEntity.location,
    maxDistance: 1.8
  })) {
    try {
      entity.applyImpulse(
        getImpulseVector(sourceEntity.location, entity.location, 1)
      );
    } catch (error) {
    }
  }
});

// data/system_template_esbuild/subscripts/equip_helmet.ts
import { system as system8, world as world10, EntityEquippableComponent, EquipmentSlot as EquipmentSlot2 } from "@minecraft/server";
function equipHelmet() {
  for (let player of world10.getAllPlayers()) {
    const armorEquipped = player.getComponent(EntityEquippableComponent.componentId);
    const hasEquippedChain = armorEquipped.getEquipment(EquipmentSlot2.Head)?.typeId == "shapescape_sdi:chain_skull_helmet";
    const hasEquippedDiamond = armorEquipped.getEquipment(EquipmentSlot2.Head)?.typeId == "shapescape_sdi:diamond_skull_helmet";
    const hasEquippedGold = armorEquipped.getEquipment(EquipmentSlot2.Head)?.typeId == "shapescape_sdi:gold_skull_helmet";
    const hasEquippedIron = armorEquipped.getEquipment(EquipmentSlot2.Head)?.typeId == "shapescape_sdi:iron_skull_helmet";
    const hasEquippedLeather = armorEquipped.getEquipment(EquipmentSlot2.Head)?.typeId == "shapescape_sdi:leather_skull_helmet";
    const hasEquippedNetherite = armorEquipped.getEquipment(EquipmentSlot2.Head)?.typeId == "shapescape_sdi:netherite_skull_helmet";
    const hasEquippedAny = hasEquippedChain || hasEquippedDiamond || hasEquippedGold || hasEquippedIron || hasEquippedLeather || hasEquippedNetherite;
    if (hasEquippedAny && player.isSprinting) {
      player.runCommand("/scriptevent shapescape_sdi:force_field_module_push force_field_push");
    }
  }
}
system8.runInterval(equipHelmet, 2);

// data/system_template_esbuild/subscripts/equip_chestplate.ts
import { system as system9, world as world11, EntityEquippableComponent as EntityEquippableComponent2, EquipmentSlot as EquipmentSlot3 } from "@minecraft/server";
var TAG_SHELL_CHESTPLATE_EFFECT = "shapescape_sdi_shell_chestplate_effect";
function equipChestplate() {
  for (let player of world11.getAllPlayers()) {
    const armorEquipped = player.getComponent(EntityEquippableComponent2.componentId);
    const hasEquippedChain = armorEquipped.getEquipment(EquipmentSlot3.Chest)?.typeId == "shapescape_sdi:chain_shell_chestplate";
    const hasEquippedDiamond = armorEquipped.getEquipment(EquipmentSlot3.Chest)?.typeId == "shapescape_sdi:diamond_shell_chestplate";
    const hasEquippedGold = armorEquipped.getEquipment(EquipmentSlot3.Chest)?.typeId == "shapescape_sdi:gold_shell_chestplate";
    const hasEquippedIron = armorEquipped.getEquipment(EquipmentSlot3.Chest)?.typeId == "shapescape_sdi:iron_shell_chestplate";
    const hasEquippedLeather = armorEquipped.getEquipment(EquipmentSlot3.Chest)?.typeId == "shapescape_sdi:leather_shell_chestplate";
    const hasEquippedNetherite = armorEquipped.getEquipment(EquipmentSlot3.Chest)?.typeId == "shapescape_sdi:netherite_shell_chestplate";
    const hasEquippedAny = hasEquippedChain || hasEquippedDiamond || hasEquippedGold || hasEquippedIron || hasEquippedLeather || hasEquippedNetherite;
    if (hasEquippedChain && player.isSneaking && !player.hasTag(TAG_SHELL_CHESTPLATE_EFFECT)) {
      player.addTag(TAG_SHELL_CHESTPLATE_EFFECT);
      player.runCommand("/effect @s resistance 999999 1 true");
      player.runCommand("/effect @s slowness 999999 5 true");
    }
    if (hasEquippedDiamond && player.isSneaking && !player.hasTag(TAG_SHELL_CHESTPLATE_EFFECT)) {
      player.addTag(TAG_SHELL_CHESTPLATE_EFFECT);
      player.runCommand("/effect @s resistance 999999 3 true");
      player.runCommand("/effect @s slowness 999999 5 true");
    }
    if (hasEquippedGold && player.isSneaking && !player.hasTag(TAG_SHELL_CHESTPLATE_EFFECT)) {
      player.addTag(TAG_SHELL_CHESTPLATE_EFFECT);
      player.runCommand("/effect @s resistance 999999 2 true");
      player.runCommand("/effect @s slowness 999999 5 true");
    }
    if (hasEquippedIron && player.isSneaking && !player.hasTag(TAG_SHELL_CHESTPLATE_EFFECT)) {
      player.addTag(TAG_SHELL_CHESTPLATE_EFFECT);
      player.runCommand("/effect @s resistance 999999 2 true");
      player.runCommand("/effect @s slowness 999999 5 true");
    }
    if (hasEquippedLeather && player.isSneaking && !player.hasTag(TAG_SHELL_CHESTPLATE_EFFECT)) {
      player.addTag(TAG_SHELL_CHESTPLATE_EFFECT);
      player.runCommand("/effect @s resistance 999999 1 true");
      player.runCommand("/effect @s slowness 999999 5 true");
    }
    if (hasEquippedNetherite && player.isSneaking && !player.hasTag(TAG_SHELL_CHESTPLATE_EFFECT)) {
      player.addTag(TAG_SHELL_CHESTPLATE_EFFECT);
      player.runCommand("/effect @s resistance 999999 3 true");
      player.runCommand("/effect @s slowness 999999 5 true");
    } else if ((!hasEquippedAny || !player.isSneaking) && player.hasTag(TAG_SHELL_CHESTPLATE_EFFECT)) {
      player.runCommand("/effect @s resistance 0");
      player.runCommand("/effect @s slowness 0");
      player.removeTag(TAG_SHELL_CHESTPLATE_EFFECT);
    }
  }
}
system9.runInterval(equipChestplate, 1);

// data/system_template_esbuild/subscripts/equip_boots.ts
import { system as system10, world as world12, EntityEquippableComponent as EntityEquippableComponent3, EquipmentSlot as EquipmentSlot4 } from "@minecraft/server";
function equipBoots() {
  for (let player of world12.getAllPlayers()) {
    const armorEquipped = player.getComponent(EntityEquippableComponent3.componentId);
    const hasEquippedChain = armorEquipped.getEquipment(EquipmentSlot4.Feet)?.typeId == "shapescape_sdi:chain_fin_boots";
    const hasEquippedDiamond = armorEquipped.getEquipment(EquipmentSlot4.Feet)?.typeId == "shapescape_sdi:diamond_fin_boots";
    const hasEquippedGold = armorEquipped.getEquipment(EquipmentSlot4.Feet)?.typeId == "shapescape_sdi:gold_fin_boots";
    const hasEquippedIron = armorEquipped.getEquipment(EquipmentSlot4.Feet)?.typeId == "shapescape_sdi:iron_fin_boots";
    const hasEquippedLeather = armorEquipped.getEquipment(EquipmentSlot4.Feet)?.typeId == "shapescape_sdi:leather_fin_boots";
    const hasEquippedNetherite = armorEquipped.getEquipment(EquipmentSlot4.Feet)?.typeId == "shapescape_sdi:netherite_fin_boots";
    const hasEquippedAny = hasEquippedChain || hasEquippedDiamond || hasEquippedGold || hasEquippedIron || hasEquippedLeather || hasEquippedNetherite;
    if (hasEquippedAny && player.isSwimming && player.runCommand("/execute if block ~ ~1 ~ water if block ~ ~2 ~ water run testfor @s").successCount) {
      player.applyKnockback(player.getViewDirection().x, player.getViewDirection().z, 0.5, player.getViewDirection().y);
    } else if (hasEquippedAny && player.isSwimming && player.runCommand("/execute if block ~ ~1 ~ water run testfor @s").successCount) {
      player.applyKnockback(player.getViewDirection().x, player.getViewDirection().z, 0.3, player.getViewDirection().y);
    } else if (hasEquippedAny && player.isSwimming) {
      player.applyKnockback(player.getViewDirection().x, player.getViewDirection().z, 0.1, player.getViewDirection().y);
    }
  }
}
system10.runInterval(equipBoots, 1);

// data/system_template_esbuild/subscripts/sensor_item.ts
import { system as system11, world as world13 } from "@minecraft/server";
var TAG_SENSOR_ITEM_COOLDOWN = "shapescape_sdi_sensor_item_cooldown";
var TAG_SENSOR_ITEM_COOLDOWN_2 = "shapescape_sdi_sensor_item_cooldown_2";
world13.afterEvents.itemUse.subscribe(async (event) => {
  const { itemStack, source } = event;
  const player = source;
  if (itemStack.typeId === "shapescape_sdi:sensor_item" && !player.hasTag(TAG_SENSOR_ITEM_COOLDOWN)) {
    player.addTag(TAG_SENSOR_ITEM_COOLDOWN);
    player.runCommand("/execute at @e[family=!inanimate,r=50,type=!item] run summon shapescape_sdi:visualizer");
    player.runCommand("/playsound shapescape_sdi.custom.visualizer.active @s");
  }
});
function sensorItemCooldown() {
  for (let player of world13.getAllPlayers()) {
    if (player.hasTag(TAG_SENSOR_ITEM_COOLDOWN) && !player.hasTag(TAG_SENSOR_ITEM_COOLDOWN_2)) {
      player.addTag(TAG_SENSOR_ITEM_COOLDOWN_2);
      let SensorCooldown = system11.runTimeout(() => {
        player.removeTag(TAG_SENSOR_ITEM_COOLDOWN);
        player.removeTag(TAG_SENSOR_ITEM_COOLDOWN_2);
        system11.clearRun(SensorCooldown);
      }, 20);
    }
  }
}
system11.runInterval(sensorItemCooldown, 5);
world13.afterEvents.playerSpawn.subscribe((event) => {
  event.player.removeTag(TAG_SENSOR_ITEM_COOLDOWN_2);
});

// data/system_template_esbuild/subscripts/default_init.ts
import { world as world14 } from "@minecraft/server";
function defaultInit() {
  let scoreboard = world14.scoreboard.getObjective("shapescape_sdi_tmp");
  if (scoreboard == void 0) {
    world14.getDimension("overworld").runCommandAsync("function shapescape/sdi/init");
  }
}
defaultInit();

// data/system_template_esbuild/subscripts/trex.ts
import {
  system as system12,
  EntityDamageCause
} from "@minecraft/server";

// data/system_template_esbuild/subscripts/trex_xmath.ts
function lerp(a, b, t) {
  return a + (b - a) * t;
}

// data/system_template_esbuild/subscripts/trex_xvect.ts
var XVect3 = class _XVect3 {
  /**
   * @param {Vector3} vect Base vector object.
   */
  constructor(vect) {
    this.x = vect.x;
    this.y = vect.y;
    this.z = vect.z;
  }
  /**
   * Returns the length of the vector.
   * @param {Vector3} vect
   * @returns {number}
   */
  static vectLength(vect) {
    return Math.sqrt(
      Math.pow(vect.x, 2) + Math.pow(vect.y, 2) + Math.pow(vect.z, 2)
    );
  }
  /**
   * Returns the length of the vector.
   * @returns {number}
   */
  length() {
    return _XVect3.vectLength(this);
  }
  /**
   * Returns the distance from one vector to another vector.
   * @param {Vector3} a
   * @param {Vector3} b
   * @returns {number}
   */
  static distanceTo(a, b) {
    return Math.sqrt(
      Math.pow(a.x - b.x, 2) + Math.pow(a.y - b.y, 2) + Math.pow(a.z - b.z, 2)
    );
  }
  /**
   * Returns the distance from this vector to another vector.
   * @param {Vector3} vect
   * @returns {number}
   */
  distanceTo(vect) {
    return _XVect3.distanceTo(this, vect);
  }
  /**
   * Returns a normalized copy of the vector, if it's a zero vector, returns the zero
   * vector.
   * @param {Vector3} vect
   * @returns {XVect3} the normalized vector
   */
  static normalized(vect) {
    let length = _XVect3.vectLength(vect);
    if (length == 0) {
      return new _XVect3({ x: 0, y: 0, z: 0 });
    }
    return new _XVect3({
      x: vect.x / length,
      y: vect.y / length,
      z: vect.z / length
    });
  }
  /**
   * Returns a normalized copy of this vector, if it's a zero vector, returns the zero
   * vector.
   * @returns {XVect3} the normalized vector
   */
  normalized() {
    return _XVect3.normalized(this);
  }
  /**
   * Subtracts two vectors and returns the result.
   * @param {Vector3} a
   * @param {Vector3} b
   * @returns {XVect3}
   */
  static sub(a, b) {
    return new _XVect3({
      x: a.x - b.x,
      y: a.y - b.y,
      z: a.z - b.z
    });
  }
  /**
   * Subtracts a vector from this vector and returns the result.
   * @param {Vector3} vect
   * @returns {XVect3}
   */
  sub(vect) {
    return _XVect3.sub(this, vect);
  }
  /**
   * Adds two vectors and returns the result.
   * @param {Vector3} a
   * @param {Vector3} b
   * @returns {XVect3}
   */
  static add(a, b) {
    return new _XVect3({
      x: a.x + b.x,
      y: a.y + b.y,
      z: a.z + b.z
    });
  }
  /**
   * Adds a vector to this vector and returns the result.
   * @param {Vector3} vect
   * @returns {XVect3}
   */
  add(vect) {
    return _XVect3.add(this, vect);
  }
  /**
   * Multiplies a vector by a scalar and returns the result.
   * @param {Vector3} vect
   * @param {number} scalar
   * @returns {XVect3}
   */
  static mul(vect, scalar) {
    return new _XVect3({
      x: vect.x * scalar,
      y: vect.y * scalar,
      z: vect.z * scalar
    });
  }
  /**
   * Multiplies this vector by a scalar and returns the result.
   * @param {number} scalar
   * @returns {XVect3}
   */
  mul(scalar) {
    return _XVect3.mul(this, scalar);
  }
  /**
   * Divides a vector by a scalar and returns the result.
   * @param {Vector3} vect
   * @param {number} scalar
   * @returns {XVect3}
   */
  static div(vect, scalar) {
    return new _XVect3({
      x: vect.x / scalar,
      y: vect.y / scalar,
      z: vect.z / scalar
    });
  }
  /**
   * Divides this vector by a scalar and returns the result.
   * @param {number} scalar
   * @returns {XVect3}
   */
  div(scalar) {
    return _XVect3.div(this, scalar);
  }
  /**
   * Returns the dot product of two vectors.
   * @param {Vector3} a 
   * @param {Vector3} b 
   * @returns {number}
   */
  static dot(a, b) {
    return a.x * b.x + a.y * b.y + a.z * b.z;
  }
  /**
   * Returns the dot product of this vector and another vector.
   * @param {Vector3} vect 
   * @returns {number}
   */
  dot(vect) {
    return _XVect3.dot(this, vect);
  }
  /**
   * Returns the cross product of two vectors.
   * @param {Vector3} a 
   * @param {Vector3} b 
   * @returns {XVect3}
   */
  static cross(a, b) {
    return new _XVect3({
      x: a.y * b.z - a.z * b.y,
      y: a.z * b.x - a.x * b.z,
      z: a.x * b.y - a.y * b.x
    });
  }
  /**
   * Returns the cross product of this vector and another vector.
   * @param {Vector3} vect 
   * @returns {XVect3}
   */
  cross(vect) {
    return _XVect3.cross(this, vect);
  }
};
function xVect3(vect) {
  return new XVect3(vect);
}

// data/system_template_esbuild/subscripts/trex.ts
var explosions = /* @__PURE__ */ new Set();
function getCenterLocation(entity) {
  let pos = xVect3(entity.getHeadLocation());
  return pos.add(entity.location).div(2);
}
function hasLineOfSight(pos, entity, dimension, maxDistance) {
  let pos2 = getCenterLocation(entity);
  let raycastOptions = {
    maxDistance,
    includePassableBlocks: false,
    includeLiquidBlocks: false
  };
  let raycastDirection = pos2.sub(pos);
  let entitiesHit = dimension.getEntitiesFromRay(
    pos,
    raycastDirection,
    raycastOptions
  );
  let entityHitDistance = void 0;
  for (let entityHit of entitiesHit) {
    if (entityHit.entity.id == entity.id) {
      entityHitDistance = entityHit.distance;
      break;
    }
  }
  if (entityHitDistance === void 0) {
    return false;
  }
  let blockHit = dimension.getBlockFromRay(
    pos,
    raycastDirection,
    raycastOptions
  );
  if (blockHit !== void 0) {
    let blockHitDistance = xVect3(blockHit.block).distanceTo(pos);
    return entityHitDistance < blockHitDistance;
  }
  return true;
}
var _TrexExplosion = class _TrexExplosion {
  /**
   * The mega Warden performing the explosion.
   * @param {Entity} megaWardenEntity
   */
  constructor(megaWardenEntity) {
    this.exploadedEntities = /* @__PURE__ */ new Set();
    this.counter = 0;
    this.location = xVect3({ x: 0, y: 0, z: 0 });
    this.dimension = megaWardenEntity.dimension;
    this.megaWardenEntity = megaWardenEntity;
    this.startExplosion();
  }
  /**
   * Starts the explosion at the given location and dimension.
   */
  startExplosion() {
    this.location = getCenterLocation(this.megaWardenEntity);
    this.exploadedEntities.clear();
    this.exploadedEntities.add(this.megaWardenEntity.id);
    this.dimension = this.megaWardenEntity.dimension;
    this.counter = -1;
    this.megaWardenEntity.runCommand("event entity @s explosion_attack");
    this.megaWardenEntity.runCommand(
      "playsound trex.charge_explosion @a ~ ~ ~ 100 1"
    );
  }
  /**
   * Ticks the explosion. Returns false if the explosion is over.
   * @returns {boolean} true if the explosion is still going on, false
   * therwise
   */
  tick() {
    if (this.counter >= _TrexExplosion.maxTicks) {
      return false;
    }
    this.counter++;
    switch (this.counter) {
      case 0:
        this.dimension.runCommand(
          `execute positioned ${this.location.x} ${this.location.y} ${this.location.z} run function shapescape/sdi/trex/explosion_attack/visuals`
        );
        break;
    }
    let currRange = Math.round(
      _TrexExplosion.maxRange * this.counter / _TrexExplosion.maxTicks
    );
    let query = { location: this.location, maxDistance: currRange };
    let entities = this.dimension.getEntities(query);
    for (let entity of entities) {
      if (!entity.isValid()) {
        continue;
      }
      if (entity.typeId === "minecraft:item") {
        continue;
      }
      if (this.exploadedEntities.has(entity.id)) {
        continue;
      }
      this.exploadedEntities.add(entity.id);
      if (!hasLineOfSight(
        this.location,
        entity,
        this.dimension,
        _TrexExplosion.maxRange
      )) {
        continue;
      }
      let lerpval = xVect3(entity.location).distanceTo(this.location) / _TrexExplosion.maxRange;
      let damage = lerp(
        _TrexExplosion.maxExplosionDamage,
        _TrexExplosion.minExplosionDamage,
        lerpval
      );
      let horizontalStrength = lerp(
        _TrexExplosion.maxKnockbackHorizontalStrength,
        _TrexExplosion.minKnockbackHorizontalStrength,
        lerpval
      );
      let verticalStrength = lerp(
        _TrexExplosion.maxKnockbackVecticalStrength,
        _TrexExplosion.minKnockbackVecticalStrength,
        lerpval
      );
      try {
        try {
          entity.applyDamage(Math.round(damage), {
            cause: EntityDamageCause.sonicBoom,
            damagingEntity: this.megaWardenEntity
          });
        } catch {
          entity.applyDamage(Math.round(damage), {
            cause: EntityDamageCause.sonicBoom
          });
        }
        entity.applyKnockback(
          entity.location.x - this.location.x,
          entity.location.z - this.location.z,
          horizontalStrength,
          verticalStrength
        );
      } catch {
      }
    }
    return true;
  }
};
// The duration of the explosion
__publicField(_TrexExplosion, "maxTicks", 10);
// The range of the explosion
__publicField(_TrexExplosion, "maxRange", 22);
// Damage properties
// INFO: full warden hunter armor reduces the sonic_boom damage type
// by a flat 8 damage points. The player has 20 health points.
__publicField(_TrexExplosion, "maxExplosionDamage", 6);
__publicField(_TrexExplosion, "minExplosionDamage", 4);
// Knockback properties
//Horizontal
__publicField(_TrexExplosion, "maxKnockbackHorizontalStrength", 11);
__publicField(_TrexExplosion, "minKnockbackHorizontalStrength", 2);
// Vertical
__publicField(_TrexExplosion, "maxKnockbackVecticalStrength", 1);
__publicField(_TrexExplosion, "minKnockbackVecticalStrength", 1);
var TrexExplosion = _TrexExplosion;
system12.runInterval(() => {
  for (let explosion of explosions) {
    if (!explosion.tick()) {
      explosions.delete(explosion);
    }
  }
}, 1);
system12.afterEvents.scriptEventReceive.subscribe((event) => {
  const sourceEntity = event.sourceEntity;
  if (sourceEntity === void 0) {
    return;
  }
  if (event.id === "shapescape_sdi:trex_explosion") {
    let explosion = new TrexExplosion(sourceEntity);
    explosions.add(explosion);
  }
});
